/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.mapping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import org.codefilarete.stalactite.mapping.RowTransformer;
import org.codefilarete.stalactite.sql.result.ColumnedRow;
import org.codefilarete.tool.Reflections;

public abstract class AbstractTransformer<C>
implements RowTransformer<C> {
    protected final Function<ColumnedRow, C> beanFactory;
    private final Collection<RowTransformer.TransformerListener<C>> rowTransformerListeners = new ArrayList<RowTransformer.TransformerListener<C>>();

    public AbstractTransformer(Class<C> clazz) {
        this((? extends ColumnedRow row) -> Reflections.newInstance((Class)clazz));
    }

    public AbstractTransformer(Function<? extends ColumnedRow, C> beanFactory) {
        this(beanFactory, Collections.emptyList());
    }

    protected AbstractTransformer(Function<? extends ColumnedRow, C> beanFactory, Collection<RowTransformer.TransformerListener<C>> rowTransformerListeners) {
        this.beanFactory = beanFactory;
        this.rowTransformerListeners.addAll(rowTransformerListeners);
    }

    public Collection<RowTransformer.TransformerListener<C>> getRowTransformerListeners() {
        return this.rowTransformerListeners;
    }

    @Override
    public void addTransformerListener(RowTransformer.TransformerListener<? extends C> listener) {
        this.rowTransformerListeners.add(listener);
    }

    @Override
    public C transform(ColumnedRow row) {
        Object bean = this.newBeanInstance(row);
        this.applyRowToBean(row, bean);
        this.rowTransformerListeners.forEach(listener -> listener.onTransform(bean, row::get));
        return bean;
    }

    @Override
    public C newBeanInstance(ColumnedRow row) {
        return this.beanFactory.apply(row::get);
    }
}

